using System;

class TrieNode
{
    public TrieNode[] Children = new TrieNode[2];
    }

    class Trie
    {
        private TrieNode root = new TrieNode();

            public void Insert(int num)
                {
                        TrieNode node = root;
                                for (int i = 31; i >= 0; i--)
                                        {
                                                    int bit = (num >> i) & 1;
                                                                if (node.Children[bit] == null)
                                                                                node.Children[bit] = new TrieNode();
                                                                                            node = node.Children[bit];
                                                                                                    }
                                                                                                        }

                                                                                                            public int GetMaxXor(int num)
                                                                                                                {
                                                                                                                        TrieNode node = root;
                                                                                                                                int maxXor = 0;
                                                                                                                                        for (int i = 31; i >= 0; i--)
                                                                                                                                                {
                                                                                                                                                            int bit = (num >> i) & 1;
                                                                                                                                                                        int oppositeBit = 1 - bit;
                                                                                                                                                                                    if (node.Children[oppositeBit] != null)
                                                                                                                                                                                                {
                                                                                                                                                                                                                maxXor |= (1 << i);
                                                                                                                                                                                                                                node = node.Children[oppositeBit];
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        else
                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                    node = node.Children[bit];
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                return maxXor;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    }

                                                                                                                                                                                                                                                                                                                    class Program
                                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                                        static int MaxXorAndProduct(int[] A, int[] B)
                                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                                    Trie trie = new Trie();
                                                                                                                                                                                                                                                                                                                                            foreach (int num in A)
                                                                                                                                                                                                                                                                                                                                                        trie.Insert(num);

                                                                                                                                                                                                                                                                                                                                                                int maxProduct = 0;
                                                                                                                                                                                                                                                                                                                                                                        foreach (int num in B)
                                                                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                                                                            int maxXor = trie.GetMaxXor(num);
                                                                                                                                                                                                                                                                                                                                                                                                        maxProduct = Math.Max(maxProduct, maxXor * num);
                                                                                                                                                                                                                                                                                                                                                                                                                }

                                                                                                                                                                                                                                                                                                                                                                                                                        return maxProduct;
                                                                                                                                                                                                                                                                                                                                                                                                                            }

                                                                                                                                                                                                                                                                                                                                                                                                                                static void Main()
                                                                                                                                                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                                                                                                                                                            int[] A = { 4, 5, 2 };
                                                                                                                                                                                                                                                                                                                                                                                                                                                    int[] B = { 0, 1, 3 };

                                                                                                                                                                                                                                                                                                                                                                                                                                                            int result = MaxXorAndProduct(A, B);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Console.WriteLine("Maksimalan proizvod je: " + result);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }